---
generated_at: 2026-01-27 12:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-npm run test-e2e-cov.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scripts.test-e2e-cov定義
- E-02: `test/e2e/check-coverage.js` - メイン処理実装
- E-03: `.github/workflows/ci.yml` - CIジョブ定義（testジョブ）
- E-04: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは`node test/e2e/check-coverage.js`を実行 | E-01 | ○ |
| C-02 | examples/からHTMLファイル一覧を取得 | E-02 (lines 10-14) | ○ |
| C-03 | index.htmlを除外する | E-02 (line 14) | ○ |
| C-04 | examples/screenshots/からファイル一覧を取得 | E-02 (lines 17-19) | ○ |
| C-05 | examples/files.jsonを読み込む | E-02 (line 24) | ○ |
| C-06 | files.jsonの全セクションからexample名を抽出 | E-02 (lines 26-30) | ○ |
| C-07 | E - S（スクリーンショット未作成）を計算 | E-02 (line 32) | ○ |
| C-08 | S - E（不要スクリーンショット）を計算 | E-02 (line 33) | ○ |
| C-09 | E - F（files.json未登録）を計算 | E-02 (line 34) | ○ |
| C-10 | F - E（不要files.json登録）を計算 | E-02 (line 35) | ○ |
| C-11 | 差分がなければ成功メッセージ出力 | E-02 (lines 37-39) | ○ |
| C-12 | スクリーンショット未作成時のエラーメッセージ | E-02 (line 43) | ○ |
| C-13 | 不要スクリーンショット時のエラーメッセージ | E-02 (line 44) | ○ |
| C-14 | files.json未登録時のエラーメッセージ | E-02 (line 45) | ○ |
| C-15 | 不要files.json登録時のエラーメッセージ | E-02 (line 46) | ○ |
| C-16 | 失敗時はexit code 1で終了 | E-02 (line 50) | ○ |
| C-17 | CIでは"Examples ready for release"ステップとして実行 | E-03 (lines 37-38) | ○ |
| C-18 | testジョブ内でlint, test-unit, test-unit-addonsの後に実行 | E-03 (lines 28-38) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなファイル比較処理で、ソースコードから完全に処理内容を把握可能
- 0: 低リスク - エラーメッセージも含めてソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] files.jsonの構造が変更された場合に正しく動作するか確認
- [ ] 新規exampleを追加した際にこのテストが適切に失敗するか確認
